<?php

   /*
    * copyright (c) 2013-2025 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */
?>

    <h4 class="mb-4 title">Prodotti installati</h4>
    <div class="well">
        In questa sezione si possono vedere i prodotti Geecom installati con il percorso per raggiungere
        la cartella amministrativa, ed è possibile modificare questo percorso in quei rari casi in cui
        ciò è necessario. Consultare il manuale di Geecom per maggiori informazioni.
    </div>
    <form class="form-horizontal" role="form" name="formImpostazioniProdotti" action="../controller/controllerImpostazioni.php" method="post" enctype="multipart/form-data">
        <div class="row mt-5">
            <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniProdottiInstallati">
            <?php 
                $queryComponentiDaMostrare = "SELECT * FROM geec_prodotti";
                $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                while($prodottoGeecom = $risComponenti->fetch_assoc()) {
                    $nomeComponente = ($prodottoGeecom["installato"] == "si") ? $prodottoGeecom["versione"] : "Geecom {$prodottoGeecom["nome"]}";
                    $nomeImmagine = "icona_Geecom_".$prodottoGeecom["nome"].".svg";
            ?>
			<div class="col">
				<div class="d-flex flex-column">									  
					<div class="d-flex align-items-center mb-3">						
						<img class="img-fluid mr-3" src="../immagini/immaginiDiSistema/<?= $nomeImmagine ?>" style="width:60px;">
						<h6><?= $nomeComponente ?></h6>
					</div>
					<div class="">
						<input type="text" class="form-control" name="percorso<?= $prodottoGeecom["nome"] ?>" value="<?= $prodottoGeecom["percorso"] ?>" placeholder="//percorso/cartella">
						<small class="form-text text-muted">Inserici il percorso della cartella amministrativa </small>
					</div>
				</div>
			</div>
            <?php
                }
            ?>
        </div>
    </form>
    <div class="footer">
        <button type="button" class="btn btn-primary float-right" onclick="document.formImpostazioniProdotti.submit()"><i class="fas fa-check"></i> Salva</button>
    </div>
